#region Using directives

using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;
using RiDNWrapper;//PTV DotNet Wrapper for RemoteInterface

#endregion

namespace DotNetExample
{
    public partial class Form1 : System.Windows.Forms.Form, IRICallback
    {
        Timer timer01 = new Timer(); //Timer
        private int m_ID = 0; //m_ID is a unique ID for the Remote Interface
        private IRI m_RI; //Access to the Remote Interface

        //Function to receive the Window Messages from the Navigationsoftware
        public void RIDataArrived(int RIMessage, object data, int ReturnValue)
        {
            //WindowMessage "GPSINFO" from Navigator
            if (RIMessage == cWndMsgs.MESSAGE_GPSINFO)
            {
                if (ReturnValue != (int)RI_Errors.RI_NOERROR)
                {
                    //Error the Navigation could not answer the Question
                }
                else if (data is cRI_CGPSInfo)
                {
                    //No Error, the Navigation has send Data for the RemoteInterface Event
                    // GPSINFO
                    
                    //Get the Data from the shared memory
                    cRI_CGPSInfo a = (cRI_CGPSInfo)data;
                    //check if received data belongs to our sent message
                    if (a.m_ID == m_ID)
                    {
                        //we are in navigation mode, and have reached our final destination
                        if ((a.flag == 1)&&(a.m_lastdestinationReached == 1))
                        {
                            //activate the button "Complete"
                            button1.Enabled = true;
                        }
                        else
                        {
                            //deactivate the button "Complete"
                            button1.Enabled = false;
                        }
                    }
                }
            }//GPSINFO
            //WindowMessage "GETSTOPOFFPOINTLIST" from Navigator
            else if (RIMessage == cWndMsgs.MESSAGE_GETSTOPOFFPOINTLIST)
            {
                if (ReturnValue != (int)RI_Errors.RI_NOERROR)
                {
                    //Error the Navigation could not answer the Question
                }
                else if (data is cRI_CGetStopOffPointList)
                {
                    //Get the Data from the shared memory
                    cRI_CGetStopOffPointList a = (cRI_CGetStopOffPointList)data;
                    //write the Information about the Stations in the list box
                    if (a.m_ID == m_ID)
                    {
                        if (a.m_index < a.m_listcount)
                        {
                            //Write the Information
                            AddListEntry("-----------", a.m_index.ToString());
                            AddListEntry("Caption", a.m_Caption);
                            AddListEntry("Description", a.m_Description);
                            AddListEntry("Mercator X", a.m_mercator_x.ToString());
                            AddListEntry("Mercator Y", a.m_mercator_y.ToString());
                            //increment the index
                            a.m_index = a.m_index + 1;
                            //Write data to the shared memory and send the Message to the
                            //Navigator to receive the next station
                            int iRet = m_RI.GetStopOffPointList_WriteData(m_ID, a);
                            if (iRet != (int)RI_Errors.RI_NOERROR)
                            {
                                //Error, Navigator is not running
                            }
                        }
                    }
                }
            }//GETSTOPOFFPOINTLIST
            //WindowMessage "STARTNAVIGATIONOVERBCR" from Navigator
            else if (RIMessage == cWndMsgs.MESSAGE_STARTNAVIGATIONOVERBCR)
            {
                //NO Error              
                if (ReturnValue == (int)RI_Errors.RI_NOERROR)
                    AddListEntry("Navigation succeeded. errorcode", cRI_Errors.Text(ReturnValue));
                //NO BCR File Found
                else if (ReturnValue == (int)RI_Errors.RI_NOTFOUND)
                    AddListEntry("Navigation not succeeded, no BCR File found. errorcode", cRI_Errors.Text(ReturnValue));
                //NO GPS Fix
                else if (ReturnValue == (int)RI_Errors.RI_NOFIX)
                    AddListEntry("Navigation not succeeded, no GPS Fix. errorcode", cRI_Errors.Text(ReturnValue));
                //NO GPS Device found
                else if (ReturnValue == (int)RI_Errors.RI_NOTAV)
                    AddListEntry("Navigation not succeeded, no GPS available. errorcode", cRI_Errors.Text(ReturnValue));
                //Navigation is running
                else if (ReturnValue == (int)RI_Errors.RI_ALREADY)
                    AddListEntry("Navigation not succeeded, Navigation is already running. errorcode", cRI_Errors.Text(ReturnValue));
                //Navigation started, but the start is retracted
                else if (ReturnValue == (int)RI_Errors.RI_START_RETRACTED)
                    AddListEntry("Navigation succeeded, start was retracted. errorcode", cRI_Errors.Text(ReturnValue));
                //Navigation started, but the target is retracted
                else if (ReturnValue == (int)RI_Errors.RI_TARGET_RETRACTED)
                    AddListEntry("Navigation succeeded, target was retracted. errorcode", cRI_Errors.Text(ReturnValue));
                //Navigation started, but the start and target is retracted
                else if (ReturnValue == (int)RI_Errors.RI_START_TARGET_RETRACTED)
                    AddListEntry("Navigation succeeded, start and target was retracted. errorcode", cRI_Errors.Text(ReturnValue));
                //all other errors
                else
                    AddListEntry("Navigation not succeeded. errorcode", cRI_Errors.Text(ReturnValue));
            }//STARTNAVIGATIONOVERBCR
            //WindowMessage "ROLLBACKTOMAINMENU" from Navigator
            else if (RIMessage == cWndMsgs.MESSAGE_ROLLBACKTOMAINMENU)
            {
                if (ReturnValue != (int)RI_Errors.RI_NOERROR)
                {
                    //Error Navigator could not switch to MainMenu
                }
                else
                {
                    //at the next step, we add a station to the stationlist
                    //count up the ID for the RemoteInterface Data
                    m_ID++;
                    //create the data struct for the Event "AddStopOffPoint"
                    cRI_CAddStopOffPoint data1 = new cRI_CAddStopOffPoint();

                    //A data example for a station in manchester
                    data1.m_mercator_x = -252585;
                    data1.m_mercator_y = 7042555;
                    data1.m_Caption = "Manchester Airport";
                    data1.m_Description = "Manchester Airport";
                    //Write data to the shared memory and send the Message to the
                    //Navigator
                    int iRet = m_RI.AddStopOffPoint_WriteData(m_ID, data1);
                    if (iRet != (int)RI_Errors.RI_NOERROR)
                    {
                        //Error, Navigator is not running
                    }

                }
            }//ROLLBACKTOMAINMENU
            //WindowMessage "ADDSTOPPOFFPOINT" from Navigator
            else if (RIMessage == cWndMsgs.MESSAGE_ADDSTOPPOFFPOINT)
            {
                if (ReturnValue == (int)RI_Errors.RI_NOERROR)
                {
                    //the station was successfully added
                    //at the third step, we start the navigation.
                    //count up the ID for the RemoteInterface Data
                    m_ID++;
                    //send the Message to the Navigator
                    int iRet = m_RI.PostMessage(cWndMsgs.MESSAGE_STARTNAVIGATION, m_ID);
                    if (iRet != (int)RI_Errors.RI_NOERROR)
                    {
                        //Error the navigator is not running
                    }

                }
                else
                {
                    //Error The station could not be added
                }
            }//ADDSTOPPOFFPOINT
            //WindowMessage "STARTNAVIGATION" from Navigator
            else if (RIMessage == cWndMsgs.MESSAGE_STARTNAVIGATION)
            {
                //NO Error              
                if (ReturnValue == (int)RI_Errors.RI_NOERROR)
                    AddListEntry("Navigation succeeded. errorcode", cRI_Errors.Text(ReturnValue));
                //NO BCR File Found
                else if (ReturnValue == (int)RI_Errors.RI_NOTFOUND)
                    AddListEntry("Navigation not succeeded, no BCR File found. errorcode", cRI_Errors.Text(ReturnValue));
                //NO GPS Fix
                else if (ReturnValue == (int)RI_Errors.RI_NOFIX)
                    AddListEntry("Navigation not succeeded, no GPS Fix. errorcode", cRI_Errors.Text(ReturnValue));
                //NO GPS Device found
                else if (ReturnValue == (int)RI_Errors.RI_NOTAV)
                    AddListEntry("Navigation not succeeded, no GPS available. errorcode", cRI_Errors.Text(ReturnValue));
                //Navigation is running
                else if (ReturnValue == (int)RI_Errors.RI_ALREADY)
                    AddListEntry("Navigation not succeeded, Navigation is already running. errorcode", cRI_Errors.Text(ReturnValue));
                //Navigation started, but the start is retracted
                else if (ReturnValue == (int)RI_Errors.RI_START_RETRACTED)
                    AddListEntry("Navigation succeeded, start was retracted. errorcode", cRI_Errors.Text(ReturnValue));
                //Navigation started, but the target is retracted
                else if (ReturnValue == (int)RI_Errors.RI_TARGET_RETRACTED)
                    AddListEntry("Navigation succeeded, target was retracted. errorcode", cRI_Errors.Text(ReturnValue));
                //Navigation started, but the start and target is retracted
                else if (ReturnValue == (int)RI_Errors.RI_START_TARGET_RETRACTED)
                    AddListEntry("Navigation succeeded, start and target was retracted. errorcode", cRI_Errors.Text(ReturnValue));
                //all other errors
                else
                    AddListEntry("Navigation not succeeded. errorcode", cRI_Errors.Text(ReturnValue));
            }//STARTNAVIGATION
        }
        public Form1()
        {
            InitializeComponent();
        }
        //Function to Call the Message "GPSINFO" in a loop
        //With this function the "complete" button will be enabled/disabled
        void timerproc(object o1, EventArgs e1)
        {
            GPS();
        }
        //Add an Entry to the ListBox
        private void AddListEntry(string sEntry)
        {
            this.lstResult.Items.Add(sEntry);
        }
        //Add an Entry to the ListBox
        private void AddListEntry(string sEntry, string sResult)
        {
            this.lstResult.Items.Add(sEntry + ": " + sResult);
        }
        //Initialize the remote interface
        public void Init(IRI ri)
        {
            m_RI = ri;
        }
        public void GPS()
        {
            //stop the timer
            timer01.Enabled = false;
            //count up the ID for the RemoteInterface Data
            m_ID++;
            //Send the WindowMessage "GPSINFO" to the Navigator
            int iRet = m_RI.PostMessage(cWndMsgs.MESSAGE_GPSINFO, m_ID);
            if (iRet != (int)RI_Errors.RI_NOERROR)
            {
                //Error, the Navigator is not running at the moment
            }
            //start the timer 
            timer01.Dispose();
            timer01.Enabled = true;
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            m_RI = new cRI();
            m_RI.Init(this);
            int hWnd = m_RI.GetTNS();
            if (hWnd == 0)
            {
               //Error Navigator not running
            } 
            //the button "Complete" is deactiveted as default
            button1.Enabled = false;

            //create a Timer and start it
            timer01.Interval = 2000;
            timer01.Tick += new EventHandler(timerproc);
            timer01.Enabled = true;
        }
        //Complete
        private void button1_Click(object sender, EventArgs e)
        {
            //ToDo, the Button "Complete" is activated and was clicked....
        }
        //Info
        private void button2_Click(object sender, EventArgs e)
        {
            //count up the ID for the RemoteInterface Data
            m_ID++;
            //create data struct for the Event "GetStopOffPointList"
            cRI_CGetStopOffPointList data = new cRI_CGetStopOffPointList();
            //Initalize index with 0
            data.m_index = 0;
            //Write the data in the shared memory an send the message to
            //the Navigator
            int iRet = m_RI.GetStopOffPointList_WriteData(m_ID, data);
            if (iRet != (int)RI_Errors.RI_NOERROR)
            {
               //Error, the Navigator is not running, please send the Message
               //again
            }
        }
        //Nav1
        private void button3_Click(object sender, EventArgs e)
        {
            //With this function you can start a navigation over a BCR File
            //count up the ID for the RemoteInterface Data
            m_ID++;
            //create the data struct for the Event "StartNavigationOverBCR"
            cRI_CStartNavigationOverBCR data = new cRI_CStartNavigationOverBCR();
            //Write the data in the shared memory an send the message to
            //the Navigator
            //m_BCRFileName == for example "tourExample"
            data.m_BCRFileName = "tourExample.bcr";
            int iRet = m_RI.StartNavigationOverBCR_WriteData(m_ID, data);
            if (iRet != (int)RI_Errors.RI_NOERROR)
            {
                //Error, the Navigator is not running, please send the Message
                //again
            }

        }
        //Nav2
        private void button4_Click(object sender, EventArgs e)
        {
            //With this function you can start a navigation with mercator coordinates
            //This feature consists of several remote interface calls
            //count up the ID for the RemoteInterface Data
            m_ID++;
            //first, set the Navigator into a consistant state
            int iRet = m_RI.PostMessage(cWndMsgs.MESSAGE_ROLLBACKTOMAINMENU, m_ID);
            if (iRet != (int)RI_Errors.RI_NOERROR)
            {
                //Error, the Navigator is not running, please send the Message
                //again
            }
            
        }

        private void button5_Click(object sender, EventArgs e)
        {
       
            //set the Navigator to Foreground

            //In C++ 
            //HWND m_Handle = FindWindow(NULL, L"navigator");
            //SetForegroundWindow(m_Handle);
        }

    }
}